<?php
/**
 * Single Product tabs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : ?>

	<div class="woocommerce-tabs">
		<ul class="tabs">
			<?php foreach ( $tabs as $key => $tab ) : ?>

				<li class="<?php echo $key ?>_tab">
					<a href="#tab-<?php echo $key ?>"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key ) ?></a>
				</li>

			<?php endforeach; ?>
			<li class="beadownloads_tab">
					<a href="#tab-beadownloads">Download</a>
            </li>

			
			</ul>
		<?php foreach ( $tabs as $key => $tab ) : ?>
		
			<div class="panel entry-content" id="tab-<?php echo $key ?>">
				<?php call_user_func( $tab['callback'], $key, $tab ) ?>
			</div>

		<?php endforeach; ?>		
		
		
		
			<div class="panel entry-content" id="tab-beadownloads">
				<?php
				
				global $product;
				$thesku = $product->get_sku();
				$languageset = 'IT';
				
				function checkRemoteFile($url)
				{
				    $ch = curl_init();
				    curl_setopt($ch, CURLOPT_URL,$url);
				    curl_setopt($ch, CURLOPT_NOBODY, 1);
				    curl_setopt($ch, CURLOPT_FAILONERROR, 1);
				    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				    if(curl_exec($ch)!==FALSE)
				    {
				        return true;
				    }
				    else
				    {
				        return false;
				    }
				}



				if( have_rows('prod_pdfs') ){
					while( have_rows('prod_pdfs') ){
						the_row(); 
						$newpdf = get_sub_field('prod_pdf');
						$newpdftitle = get_sub_field('pdf_title');
						echo '<br /><a href="'.$newpdf.'" target="_blank"/>'.$newpdftitle.'</a>';
						}
				}

				
				$prod_sheet_path = 'http://www.beafastenersusa.com/pdfs/'.$thesku.'-'.$languageset.'-Productsheet.pdf';
				$prod_sheet_name =  $thesku.'-'.$languageset.'-Productsheet.pdf';
				$prod_headers= get_headers($prod_sheet_path, 1);
				$url = $prod_sheet_path;
				$prodcheck = checkRemoteFile($url);
				
				$us_prod_sheet_path = 'http://www.beafastenersusa.com/pdfs/'.$thesku.'-US-Productsheet.pdf';
				$us_prod_sheet_name =  $thesku.'-US-Productsheet.pdf';
				$us_prod_headers= get_headers($us_prod_sheet_path, 1);
				$us_url = $us_prod_sheet_path;
				$us_prodcheck = checkRemoteFile($us_url);

				$en_prod_sheet_path = 'http://www.beafastenersusa.com/pdfs/'.$thesku.'-EN-Productsheet.pdf';
				$en_prod_sheet_name =  $thesku.'-US-Productsheet.pdf';
				$en_prod_headers= get_headers($en_prod_sheet_path, 1);
				$en_url = $en_prod_sheet_path;
				$en_prodcheck = checkRemoteFile($en_url);

				$de_prod_sheet_path = 'http://www.beafastenersusa.com/pdfs/'.$thesku.'-DE-Productsheet.pdf';
				$de_prod_sheet_name =  $thesku.'-US-Productsheet.pdf';
				$de_prod_headers= get_headers($de_prod_sheet_path, 1);
				$de_url = $us_prod_sheet_path;
				$de_prodcheck = checkRemoteFile($de_url);					
				
				if(true == $prodcheck){
					echo '<br /><a href ="http://www.beafastenersusa.com/pdfs/'.$thesku.'-'.$languageset.'-Productsheet.pdf" target="_blank"/>'.$prod_sheet_name.'</a>';
				}else if (true == $us_prodcheck){
					echo '<br /><a href ="http://www.beafastenersusa.com/pdfs/'.$thesku.'-US-Productsheet.pdf" target="_blank"/>'.$us_prod_sheet_name.'</a>';
				}else if(true == $de_prodcheck){
					echo '<br /><a href ="http://www.beafastenersusa.com/pdfs/'.$thesku.'-DE-Productsheet.pdf" target="_blank"/>'.$de_prod_sheet_name.'</a>';
				}else if(true == $en_prodcheck){
					echo '<br /><a href ="http://www.beafastenersusa.com/pdfs/'.$thesku.'-EN-Productsheet.pdf" target="_blank"/>'.$en_prod_sheet_name.'</a>';
				}
				
				$sparepart_path = 'http://www.beafastenersusa.com/pdfs/'.$thesku.'-Sparepart.pdf';
				$sparepart_name =  $thesku.'_Sparepart.pdf';
				$sparepart_headers= get_headers($prod_sheet_path, 1);		
				$url = $prod_sheet_path;
				$sparecheck = checkRemoteFile($url);
				if(true == $sparecheck){
					echo '<br /><a href="http://www.beafastenersusa.com/pdfs/'.$thesku.'-Sparepart.pdf" target="_blank"/>'.$sparepart_name.'</a>';
				}else{
					echo '<br /><a href="http://www.beafastenersusa.com/pdfs/'.$thesku.'-Sparepart.pdf" target="_blank"/>'.$sparepart_name.'</a>';
				}				
				?>
								<?php     echo do_shortcode('[ssba]'); ?>

			</div>		
			
			
			
			
	</div>

<?php endif; ?>
