<?php
/**
 * Single Product Meta
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

$cat_count = sizeof( get_the_terms( $post->ID, 'product_cat' ) );
$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );

?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>

		<span class="sku_wrapper"><?php _e( '<strong>SKU: </strong>', 'woocommerce' ); ?> <span class="sku" itemprop="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : __( 'N/A', 'woocommerce' ); ?></span>.</span><br />

	<?php endif; ?>

	<?php echo $product->get_categories( ', ', '<span class="posted_in">' . _n( '<strong>Category: </strong>', '<strong>Kategorie </strong>', $cat_count, 'woocommerce' ) . ' ', '.</span>' ); ?>

	<?php echo $product->get_tags( ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', $tag_count, 'woocommerce' ) . ' ', '.</span>' ); ?>

	<?php //do_action( 'woocommerce_product_meta_end' );

echo '<br /><strong>Spona: </strong>';

$fasteners = get_the_terms( $product->id, 'pa_fastener');
$term_list = wp_get_post_terms($post->ID,'pa_fastener',array('fields'=>'ids'));

$fastenermets = get_the_terms( $product->id, 'pa_fastener-metric');

if ( ! empty( $fastenermets ) && ! is_wp_error( $fastenermets ) ){
echo '<span class="metdisp">';
	foreach ( $fastenermets as $fastenermet ) {
		 $fastener_id = (int)$term_list[0];
		echo ' <a href="http://www.beafastenersusa.com/cz/product-category/tools/?filtering=1&filter_fastener='.$fastener_id.'">' . $fastenermet->name . '</a>';
	}echo '</span>';
}


if ( ! empty( $fasteners ) && ! is_wp_error( $fasteners ) ){
echo '<span class="usdisp">';
	foreach ( $fasteners as $fastener ) {
		 $fastener_id = (int)$term_list[0];
		echo ' <a href="http://www.beafastenersusa.com/cz/product-category/tools/?filtering=1&filter_fastener='.$fastener_id.'">' . $fastener->name . '</a>';
	}echo '</span>';
}
	?>

</div>
